/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import java.io.*;
import java.net.*;

import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

/** This class represents the base class for all SignalEvents.  SignalEvents inform the application
 *  about incoming requests from peer applications and to support complex event driven applications.
 */
public class SignalEvent {
	/**  Invite Packet received from peer  **/
	protected InvitePacket myInviteInfo = null;
	/**  SignalConnection object  **/
	protected SignalConnection mySC = null;
	/**  The DesktopSignaling object that generated the event  **/
	protected DesktopSignaling myDS = null;
	
	/** Default Constructor
	 * 
	 * @param None.
	 * @return void.
	 */
	public SignalEvent(){
		this(null, null, null);
	}
	
	/** Constructor
	 * 
	 * @param ip is the InvitePacket received from the peer
	 */
	public SignalEvent(InvitePacket ip){
		this(ip, null, null);
	}
	
	/** Constructor
	 * 
	 * @param ip is the InvitePacket received from the peer
	 * @param sc is the SignalConnection object to used
	 */
	public SignalEvent(InvitePacket ip, SignalConnection sc){
		this(ip, sc, null);
	}

	/** Constructor
	 * 
	 * @param ip is the InvitePacket received from the peer
	 * @param sc is the SignalConnection object to used
	 * @param ds is the DesktopSignaling handle
	 */
	public SignalEvent(InvitePacket ip, SignalConnection sc, DesktopSignaling ds){
		myInviteInfo = ip;
		mySC = sc;
		myDS = ds;
	}
	
	/**
	 * @return the InvitePacket received from the peer application
	 */
	public InvitePacket getInvitePacket(){
		return myInviteInfo;
	}
		
	/**
	 * @return the peer's UserID
	 */
	public UserID getSenderID(){
		return myInviteInfo.getSenderID();
	}
	
	/**
	 * @return the peer's Location object
	 * @see cnrg.itx.ds.Location
	 */
	public Location getSenderLoc(){
		return myInviteInfo.getSenderLoc();
	}
	
	/**
	 * @return the peer's string description
	 */
	public String getDescription(){
		return myInviteInfo.getDescription();
	}
	
	/**
	 * @return the SignalConnection object
	 */
	public SignalConnection getSignalConnection(){
		return mySC;
	}
	
	/**
	 * @return the DesktopSignaling object
	 */
	public DesktopSignaling getDesktopSignaling(){
		return myDS;
	}

	/** This method sets the SignalConnection object to be used
	 * 
	 * @param sc is the SignalConnection object
	 * @return void
	 */
	public void setSignalConnection(SignalConnection sc){
		mySC = sc;
	}
	
	/** This method sets the DesktopSignaling object
	 * 
	 * @param ds is the DesktopSignaling object
	 * @return void
	 */
	public void setDesktopSignaling(DesktopSignaling ds){
		myDS = ds;
	}	
}